local configPath = "go_fletch"
local registerRecipes = require("mer.goFletch.registerRecipes")
local config = mwse.loadConfig(configPath)
if (config == nil) then
	config = {
        fletchFromInventory = false,
        dontShowAgain = false
    }
end


--INITIALISE SKILLS--
local skillModule = include("OtherSkills.skillModule")

--Initialise Recipes



local function noSkillsMessage(e)
    if e.button == 0 then
        os.execute("start https://www.nexusmods.com/morrowind/mods/46034")
    elseif e.button == 1 then
        config.dontShowAgain = true
        mwse.saveConfig(configPath, config)
    end
end

local charGen
local function checkCharGen()
    if charGen.value == -1 then
        if ( not skillModule ) and ( not config.dontShowAgain ) then
            tes3.messageBox({
                message = "       !",
                buttons = { "     Nexus", "  ", ""},
                callback = noSkillsMessage
            })
        end
        event.unregister("simulate", checkCharGen)
        local agilBase = tes3.mobilePlayer.attributes[tes3.attribute.agility + 1].base
        local startingSkill = math.remap(agilBase, 0, 100, 10, 20)

        local fletchingDescription = (
            "     ,      .        ."
        )
        skillModule.registerSkill(
            "fletching",
            {
                name = "",
                icon = "Icons/fletching/skill.dds",
                value = startingSkill,
                attribute =  tes3.attribute.agility,
                description = fletchingDescription,
                specialization = tes3.specialization.stealth
            }
        )
    end
end
local function onSkillsReady()
    charGen = tes3.findGlobal("CharGenState")
    event.unregister("simulate", checkCharGen)
    event.register("simulate", checkCharGen)
end
event.register("OtherSkills:Ready", onSkillsReady)


-- local function fletchTooltip(e)
--     if e.object.id == "mer_fletch_kit" then
--         e.tooltip:findChild(tes3ui.registerID("HelpMenu_uses")).visible = false
--         e.tooltip:findChild(tes3ui.registerID("HelpMenu_qualityCondition")).visible = false
--     end
-- end

-- event.register("uiObjectTooltip", fletchTooltip)

local function initialised()
    mwse.log("Registering Fletching Recipes")
    registerRecipes()
end

event.register("initialized", initialised)



--------------------------------------------
--MCM
--------------------------------------------

local function registerMCM()
    local  sideBarDefault = (
        "       \"\", " ..
        "   MWSE   , " ..
        "       . \n\n" ..
        "         " ..
        " ,    ,   " ..
        "  . ,   : ,  " ..
        " . \n\n" ..
        "          " ..
        "\" \".      10  20 " ..
        "   ."
    )
    local function addSideBar(component)
        component.sidebar:createInfo{ text = sideBarDefault}
        local hyperlink = component.sidebar:createCategory(": ")
        hyperlink:createHyperLink{
            text = ": Merlord",
            exec = "start https://www.nexusmods.com/users/3040468?tab=user+files",
        }
        hyperlink:createHyperLink{
            text = ": Remiros",
            exec = "start https://www.nexusmods.com/morrowind/users/899234?tab=user+files",
        }
    end

    local  fletchFromInventoryDescription = (
        "   ,       ,  " ..
        "    .   ,   " ..
        "    ,     ."
    )


    local template = mwse.mcm.createTemplate("")
    template:saveOnClose(configPath, config)
    local page = template:createSideBarPage{}
    addSideBar(page)

    page:createOnOffButton{
        label = "  ",
        variable = mwse.mcm.createTableVariable{
            id = "fletchFromInventory",
            table = config
        },
        description = fletchFromInventoryDescription
    }

    template:register()
end

event.register("modConfigReady", registerMCM)